@ECHO OFF

ECHO .
ECHO .
ECHO Sprite Assembler Tutorial #5:  Resizing and Aspect Ratios
ECHO .
ECHO .
ECHO This tutorial will execute the following commands:
ECHO   sprtasm -h48 -w48 -f logo.bmp -- tutor5a.bmp
ECHO   sprtasm -h48 -w48 -a- -f logo.bmp -- tutor5b.bmp
ECHO   sprtasm -h48 -w48 -a+ -f logo.bmp -- tutor5c.bmp
ECHO .
ECHO If the program asks if you want to replace an existing file, press "Y".
ECHO .
ECHO .
PAUSE

IF EXIST sprtasm.exe GOTO run1
IF EXIST ..\sprtasm.exe GOTO run2

ECHO .
ECHO .
ECHO ***ERROR***
ECHO .
ECHO Could not find SPRTASM.EXE in either this directory or in the
ECHO parent directory.  Please ensure you are running this from the 
ECHO "tutor" subdirectory.

:run1
sprtasm -h48 -w48 -f logo.bmp -- tutor5a.bmp
ECHO .
ECHO .
sprtasm -h48 -w48 -a- -f logo.bmp -- tutor5b.bmp
ECHO .
ECHO .
sprtasm -h48 -w48 -a+ -f logo.bmp -- tutor5c.bmp
ECHO .
ECHO .
GOTO end

:run2
..\sprtasm -h48 -w48 -f logo.bmp -- tutor5a.bmp
ECHO .
ECHO .
..\sprtasm -h48 -w48 -a- -f logo.bmp -- tutor5b.bmp
ECHO .
ECHO .
..\sprtasm -h48 -w48 -a+ -f logo.bmp -- tutor5c.bmp
ECHO .
ECHO .
GOTO end

:end
ECHO .
ECHO .
ECHO .
ECHO Look at the original file LOGO.BMP.  It is 128 pixels wide and 64
ECHO pixels tall.  We want to resize it to 48 by 48.  If we just use
ECHO "-h48 -w48" the result looks squished (see TUTOR5A.BMP).  However
ECHO by using the "-a-" or "-a+" switches we can keep the original
ECHO aspect ratio.  
ECHO .
ECHO See TUTOR5B.BMP.  For this file we used "-a-" which told the program
ECHO to decrease either the height or width as appropriate to maintain
ECHO the aspect ratio.  Since we gave "-h48 -w48" it will keep one of 
ECHO these while decreasing the other.  So the resulting bitmap has a
ECHO width of 48 and a height of 24.
ECHO .
PAUSE
ECHO .
ECHO Similarly look at TUTOR5C.BMP.  Here we used "-a+".  This keeps
ECHO either the height or width while *increasing* the other to maintain
ECHO the aspect ratio.  Notice the resulting bitmap is 96 pixels tall and
ECHO 48 pixels wide (it kept the width and increased the height to match
ECHO the 2:1 original's aspect ratio).
ECHO .
ECHO That completes the tutorials!  Experiment with the program to find
ECHO out what it can do for you.  You can contact the author Scott Cartier
ECHO at dsyaroze@concentric.net with bugs or questions.
ECHO .
ECHO .

