@ECHO OFF

ECHO .
ECHO .
ECHO Sprite Assembler Tutorial #4:  Tolerance
ECHO .
ECHO .
ECHO This tutorial will execute the following commands:
ECHO   sprtasm -ci -crb -f cross.bmp -- tutor4a.bmp
ECHO   sprtasm -ci -crb -t230 -f cross.bmp -- tutor4b.bmp
ECHO   sprtasm -ci -crb -t230 -tc -f cross.bmp -- tutor4c.bmp
ECHO   sprtasm -ci -crb -t350 -f cross.bmp -- tutor4d.bmp
ECHO   sprtasm -ci -crb -t350 -tc -f cross.bmp -- tutor4e.bmp
ECHO .
ECHO If the program asks if you want to replace an existing file, press "Y".
ECHO .
ECHO .
PAUSE

IF EXIST sprtasm.exe GOTO run1
IF EXIST ..\sprtasm.exe GOTO run2

ECHO .
ECHO .
ECHO ***ERROR***
ECHO .
ECHO Could not find SPRTASM.EXE in either this directory or in the
ECHO parent directory.  Please ensure you are running this from the 
ECHO "tutor" subdirectory.

:run1
sprtasm -ci -crb -f cross.bmp -- tutor4a.bmp
ECHO .
ECHO .
sprtasm -ci -crb -t230 -f cross.bmp -- tutor4b.bmp
ECHO .
ECHO .
sprtasm -ci -crb -t230 -tc -f cross.bmp -- tutor4c.bmp
ECHO .
ECHO .
sprtasm -ci -crb -t350 -f cross.bmp -- tutor4d.bmp
ECHO .
ECHO .
sprtasm -ci -crb -t350 -tc -f cross.bmp -- tutor4e.bmp
ECHO .
ECHO .
GOTO end

:run2
..\sprtasm -ci -crb -f cross.bmp -- tutor4a.bmp
ECHO .
ECHO .
..\sprtasm -ci -crb -t230 -f cross.bmp -- tutor4b.bmp
ECHO .
ECHO .
..\sprtasm -ci -crb -t230 -tc -f cross.bmp -- tutor4c.bmp
ECHO .
ECHO .
..\sprtasm -ci -crb -t350 -f cross.bmp -- tutor4d.bmp
ECHO .
ECHO .
..\sprtasm -ci -crb -t350 -tc -f cross.bmp -- tutor4e.bmp
ECHO .
ECHO .
GOTO end

:end
ECHO .
ECHO .
ECHO .
ECHO TUTOR4A.BMP is cropped like normal with no tolerance.  TUTOR4B.BMP
ECHO and TUTOR4C.BMP are both cropped with a tolerance of 230 so the
ECHO darker gray gets cropped.  Note that in TUTOR4C.BMP we used tolerance
ECHO conversion to remove the darker gray entirely.  Similarly TUTOR4D.BMP
ECHO and TUTOR4E.BMP used a tolerance of 350 so that only the white is
ECHO left uncropped.  But with TUTOR4E.BMP we used "-tc" to convert the
ECHO colors to tolerance.  This changed all the gray pixels to black,
ECHO leaving only the white.
ECHO .
ECHO .

