@ECHO OFF

ECHO .
ECHO .
ECHO Sprite Assembler Tutorial #3:  Individual vs. Worst-Case Cropping
ECHO .
ECHO .
ECHO This tutorial will execute the following commands:
ECHO   sprtasm -ci -cr0,0 -f ball0000.bmp+ -- tutor3a.bmp
ECHO   sprtasm -cw -cr0,0 -f ball0000.bmp+ -- tutor3b.bmp
ECHO .
ECHO If the program asks if you want to replace an existing file, press "Y".
ECHO .
ECHO .
PAUSE

IF EXIST sprtasm.exe GOTO run1
IF EXIST ..\sprtasm.exe GOTO run2

ECHO .
ECHO .
ECHO ***ERROR***
ECHO .
ECHO Could not find SPRTASM.EXE in either this directory or in the
ECHO parent directory.  Please ensure you are running this from the 
ECHO "tutor" subdirectory.

:run1
sprtasm -ci -cr0,0 -f ball0000.bmp+ -- tutor3a.bmp
ECHO .
ECHO .
sprtasm -cw -cr0,0 -f ball0000.bmp+ -- tutor3b.bmp
GOTO end

:run2
..\sprtasm -ci -cr0,0 -f ball0000.bmp+ -- tutor3a.bmp
ECHO .
ECHO .
..\sprtasm -cw -cr0,0 -f ball0000.bmp+ -- tutor3b.bmp
GOTO end

:end
ECHO .
ECHO .
ECHO .
ECHO This tutorial shows the difference between individual cropping and
ECHO worst-case cropping.  Look at the original files BALL0000.BMP, 
ECHO BALL0001.BMP, BALL0002.BMP, and BALL0003.BMP.  It's an animation of
ECHO a ball bouncing.  Now see what happened when we cropped individually
ECHO (using "-ci") in the output TUTOR3A.BMP.  Not exactly very useful.
ECHO .
ECHO If we use worst-case cropping (using "-cw") we get what we want.
ECHO Look at TUTOR3B.BMP.  The bouncing animation was preserved.
ECHO .
ECHO One other item.  Notice how we used the shorthand notation for
ECHO specifying input files.  Since our animation frames were named
ECHO BALL0000.BMP, BALL0001.BMP, BALL0002.BMP, and BALL0003.BMP we just
ECHO specified the first frame and appended a "+" afterward.  This made
ECHO the program pick up all the subsequent frames.
ECHO   sprtasm -ci -cr0,0 -f ball0000.bmp+ -- tutor3a.bmp
ECHO   sprtasm -cw -cr0,0 -f ball0000.bmp+ -- tutor3b.bmp
ECHO .
ECHO .

