@ECHO OFF

ECHO .
ECHO .
ECHO Sprite Assembler Tutorial #2:  Cropping Using Coordinates
ECHO .
ECHO .
ECHO This tutorial will execute the following commands:
ECHO   sprtasm -ci -c0,0 -f smilyblk.bmp -- tutor2a.bmp
ECHO   sprtasm -ci -c0,0 -f smilyred.bmp -- tutor2b.bmp
ECHO .
ECHO If the program asks if you want to replace an existing file, press "Y".
ECHO .
ECHO .
PAUSE

IF EXIST sprtasm.exe GOTO run1
IF EXIST ..\sprtasm.exe GOTO run2

ECHO .
ECHO .
ECHO ***ERROR***
ECHO .
ECHO Could not find SPRTASM.EXE in either this directory or in the
ECHO parent directory.  Please ensure you are running this from the 
ECHO "tutor" subdirectory.

:run1
sprtasm -ci -cr0,0 -f smilyblk.bmp -- tutor2a.bmp
ECHO .
ECHO .
sprtasm -ci -cr0,0 -f smilyred.bmp -- tutor2b.bmp
GOTO end

:run2
..\sprtasm -ci -cr0,0 -f smilyblk.bmp -- tutor2a.bmp
ECHO .
ECHO .
..\sprtasm -ci -cr0,0 -f smilyred.bmp -- tutor2b.bmp
GOTO end

:end
ECHO .
ECHO .
ECHO .
ECHO Now look at TUTOR2A.BMP and TUTOR2B.BMP.  They are both cropped
ECHO correctly.  When we used "-cr0,0" we told the program to take whatever
ECHO color was at coordinates 0,0 (the upper-left corner) and use that as
ECHO the background.  So for the first picture it used black while for the
ECHO second it used red.
ECHO .
ECHO .

