@ECHO OFF

ECHO .
ECHO .
ECHO Sprite Assembler Tutorial #1:  Cropping With Black
ECHO .
ECHO .
ECHO This tutorial will execute the following commands:
ECHO   sprtasm -ci -crb -f smilyblk.bmp -- tutor1a.bmp
ECHO   sprtasm -ci -crb -f smilyred.bmp -- tutor1b.bmp
ECHO .
ECHO If the program asks if you want to replace an existing file, press "Y".
ECHO .
ECHO .
PAUSE

IF EXIST sprtasm.exe GOTO run1
IF EXIST ..\sprtasm.exe GOTO run2

ECHO Could not find SPRTASM.EXE in either this directory or in the
ECHO parent directory.  Please ensure you are running this from the 
ECHO "tutor" subdirectory.

:run1
sprtasm -ci -crb -f smilyblk.bmp -- tutor1a.bmp
ECHO .
ECHO .
sprtasm -ci -crb -f smilyred.bmp -- tutor1b.bmp
GOTO end

:run2
..\sprtasm -ci -crb -f smilyblk.bmp -- tutor1a.bmp
ECHO .
ECHO .
..\sprtasm -ci -crb -f smilyred.bmp -- tutor1b.bmp
GOTO end

:end
ECHO .
ECHO .
ECHO .
ECHO Take a look at TUTOR1A.BMP and TUTOR1B.BMP.  See how the first one
ECHO was cropped correctly, but the second was not.  This is because we
ECHO used the "-crb" parameter.  Since there is no black in the second
ECHO file it was not cropped at all!
ECHO .
ECHO Now run TUTOR2.BAT to see how we can fix this.
ECHO .
ECHO .

